﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace WindowsFormsApplication1
{
    public partial class Form2 : Form
    {
        // Object for FormMain.
        private FormMain formMain;


        public Form2(FormMain formMain)
        {
            InitializeComponent();

            this.formMain = formMain;
        }



        private void Form2_Load(object sender, EventArgs e)
        {
            // Refresh the New Baud Rate combo box.
            this.refreshNewBaudRateList();
        }



        // User clicks the "Set" button.
        private void buttonSet_Click(object sender, EventArgs e)
        {
            // Value for baud rate.
            Int16 baudRate = 1;

            switch (Convert.ToInt32(this.comboBoxNewBaud.SelectedItem))
            {
                case 4800:
                    baudRate = 0;
                    break;

                case 9600:
                    baudRate = 1;
                    break;

                case 19200:
                    baudRate = 2;
                    break;

                case 38400:
                    baudRate = 3;
                    break;

                case 57600:
                    baudRate = 4;
                    break;

                case 115200:
                    baudRate = 5;
                    break;
            }

            // Send command to set the new baud rate.
            this.formMain.bld04aCommand.setBaudRate(baudRate);

            MessageBox.Show("Please reconnect with the new baud rate.", "Info");
            
            // Disconnect the serial port.
            this.formMain.disconnectSerialPort();

            this.Close();
        }



        // User clicks the "Cancel" button.
        private void buttonCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }



        // Refresh the New Baud Rate List combo box.
        private void refreshNewBaudRateList()
        {
            // Clear all the items in the combo box.
            this.comboBoxNewBaud.Items.Clear();

            // Add the items to the combo box.
            this.comboBoxNewBaud.Items.Add(4800);
            this.comboBoxNewBaud.Items.Add(9600);
            this.comboBoxNewBaud.Items.Add(19200);
            this.comboBoxNewBaud.Items.Add(38400);
            this.comboBoxNewBaud.Items.Add(57600);
            this.comboBoxNewBaud.Items.Add(115200);

            // Select 9600 as default baud rate.
            this.comboBoxNewBaud.SelectedIndex = this.comboBoxNewBaud.Items.IndexOf(9600);
        }

    }
}
